/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category.table;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.compat.jei.JeiCompat;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EliteTableCategory
implements IRecipeCategory<ITableRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("extendedcrafting", "elite_crafting");
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/elite_crafting.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable required;
    private final IDrawable shapeless;

    public EliteTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 126, 159);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.ELITE_TABLE.get()));
        this.required = helper.createDrawable(JeiCompat.ICONS, 0, 0, 15, 15);
        this.shapeless = helper.createDrawable(JeiCompat.ICONS, 17, 0, 19, 15);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ITableRecipe> getRecipeClass() {
        return ITableRecipe.class;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.elite_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ITableRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        stack.m_85836_();
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        if (recipe.hasRequiredTier()) {
            this.required.draw(stack, shapeless ? 217 : 237, 257);
        }
        if (shapeless) {
            this.shapeless.draw(stack, 237, 257);
        }
        stack.m_85849_();
    }

    public List<Component> getTooltipStrings(ITableRecipe recipe, double mouseX, double mouseY) {
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        int sX = (shapeless ? 217 : 237) / 2;
        int sY = 128;
        if (recipe.hasRequiredTier() && mouseX > (double)(sX - 1) && mouseX < (double)(sX + 8) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return Collections.singletonList(ModTooltips.REQUIRES_TABLE.args(new Object[]{recipe.getTier()}).color(ChatFormatting.WHITE).build());
        }
        if (shapeless && mouseX > (double)(sX + 10) && mouseX < (double)(sX + 20) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return Collections.singletonList(Localizable.of((String)"jei.tooltip.shapeless.recipe").build());
        }
        return Collections.emptyList();
    }

    public void setIngredients(ITableRecipe recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        ingredients.setInputIngredients((List)recipe.m_7527_());
    }

    public void setRecipe(IRecipeLayout layout, ITableRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 65, 137);
        stacks.set(0, outputs);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int index = 1 + j + i * 7;
                stacks.init(index, true, j * 18, i * 18);
            }
        }
        if (recipe instanceof ShapedTableRecipe) {
            ShapedTableRecipe shaped = (ShapedTableRecipe)recipe;
            int heightOffset = Math.floorDiv(7 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(7 - shaped.getWidth(), 2);
            int stackIndex = 0;
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    int index = 1 + i * 7 + j;
                    stacks.set(index, (List)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
        } else if (recipe instanceof ShapelessTableRecipe) {
            for (int i = 0; i < inputs.size(); ++i) {
                stacks.set(i + 1, (List)inputs.get(i));
            }
        }
        layout.moveRecipeTransferButton(113, 146);
    }
}

